; Script generated by the Inno Setup Script Wizard.
; SEE THE DOCUMENTATION FOR DETAILS ON CREATING INNO SETUP SCRIPT FILES!

#define MyAppName           "Ʈٴ Ŵ"
#define MyAppVersion        "3.0"
#define MyAppVerName        "36.MR"
#define MyAppBuildData      "B23031701.LGC"
#define MyAppPublisher      "()Ѿ"
#define MyAppURL            "http://www.fontbada.co.kr/"
#define MyAppFolderName     "FontbadaManager"
#define MyAppDataName       "fontbada3"
#define MyAppProcessName    "FontManager"
#define MyAppPrjFilePath    "{pf}\hanyang"
#define MyAppRootPath       "{localappdata}\hanyang"
#define MyAppWindowName     "FontbadaManager"
#define MyAppFilter         "fontmanager.exe"


[Setup]
; NOTE: The value of AppId uniquely identifies this application.
; Do not use the same AppId value in installers for other applications.
; (To generate a new GUID, click Tools | Generate GUID inside the IDE.)
AppId                       = {{A2670E5F-4D34-4042-A9C5-5A3BC9547B37}
AppName                     = {#MyAppName}
AppVersion                  = {#MyAppVersion}
AppVerName                  = {#MyAppName}
AppPublisher                = {#MyAppPublisher}
CreateAppDir                = no
OutputDir                   = ./Output
OutputBaseFilename          = FontBada3_Manager_Setup-{#MyAppVersion}.{#MyAppVerName}{#MyAppBuildData}
Compression                 = lzma
SolidCompression            = yes
DisableProgramGroupPage     = yes
SetupIconFile               = fontmanager.ico
LicenseFile                 = License.txt
WizardImageFile             = wizard.bmp
DisableReadyPage            = yes
AppCopyright                = Copyright  2017 by ()Ѿ All Rights Reserved.
VersionInfoVersion          = 1.0.0.0
Uninstallable               = true
;PrivilegesRequired         = admin


[Messages]


[Languages]
Name: Korean; MessagesFile: "Korean.isl";


[Files]
;  
Source: "FontManager/FontManager.exe";                              DestDir: "{#MyAppPrjFilePath}\{#MyAppFolderName}\";                         Flags: ignoreversion
Source: "FontManager/FontManager.exe.config";                       DestDir: "{#MyAppPrjFilePath}\{#MyAppFolderName}\";                         Flags: ignoreversion
Source: "FontManager/FONTBADA_UPDATER.exe";                         DestDir: "{#MyAppRootPath}\{#MyAppDataName}\";                              Flags: ignoreversion


; ߰ ̺귯
Source: "FontManager/Newtonsoft.Json.dll";                          DestDir: "{#MyAppPrjFilePath}\{#MyAppFolderName}\";                         Flags: ignoreversion


; Ʈ 
Source: "fonts/H2BDAB.TTF";                                 DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/H2BDAL.TTF";                                 DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/H2BDAM.TTF";                                 DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/H2BDRM.TTF";                                 DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/H2BRMB.TTF";                                 DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/H2BRML.TTF";                                 DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/H2BRMM.TTF";                                 DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/H2BSRB.TTF";                                 DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/H2BULB.TTF";                                 DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/H2BULL.TTF";                                 DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/H2BULM.TTF";                                 DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/H2CJIA.TTF";                                 DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/H2CJIB.TTF";                                 DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/H2CSWB.TTF";                                 DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/H2CSWE.TTF";                                 DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/H2CSWM.TTF";                                 DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/H2CYSB.TTF";                                 DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/H2CYSL.TTF";                                 DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/H2CYSM.TTF";                                 DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/H2DNKB.TTF";                                 DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/H2DNKL.TTF";                                 DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/H2DNKM.TTF";                                 DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/H2DRRB.TTF";                                 DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/H2DRRM.TTF";                                 DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/H2GPRB.TTF";                                 DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/H2GPRM.TTF";                                 DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/H2GPSM.TTF";                                 DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/H2GSRB.TTF";                                 DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/H2GTRB.TTF";                                 DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/H2GTRE.TTF";                                 DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/H2GTRL.TTF";                                 DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/H2GTRM.TTF";                                 DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/H2GTTB.TTF";                                 DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/H2HDKB.TTF";                                 DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/H2HDKM.TTF";                                 DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/H2HDRB.TTF";                                 DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/H2HDRM.TTF";                                 DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/H2HSRM.TTF";                                 DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/H2INYB.TTF";                                 DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/H2INYL.TTF";                                 DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/H2INYM.TTF";                                 DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/H2KANB.TTF";                                 DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/H2KANL.TTF";                                 DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/H2KANM.TTF";                                 DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/H2KGSB.TTF";                                 DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/H2KGSE.TTF";                                 DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/H2KGSL.TTF";                                 DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/H2KGSM.TTF";                                 DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/H2MJMM.TTF";                                 DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/H2MJRB.TTF";                                 DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/H2MJRE.TTF";                                 DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/H2MJRL.TTF";                                 DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/H2MJRM.TTF";                                 DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/H2MJRU.TTF";                                 DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/H2MJSB.TTF";                                 DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/H2MJSM.TTF";                                 DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/H2MJUM.TTF";                                 DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/H2MKPB.TTF";                                 DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/H2MKRB.TTF";                                 DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/H2MPPB.TTF";                                 DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/H2MPPL.TTF";                                 DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/H2MPRB.TTF";                                 DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/H2MPRL.TTF";                                 DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/H2MPTB.TTF";                                 DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/H2MPTE.TTF";                                 DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/H2MPTM.TTF";                                 DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/H2NAMB.TTF";                                 DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/H2NAML.TTF";                                 DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/H2NAMM.TTF";                                 DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/H2NGTM.TTF";                                 DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/H2PIRL.TTF";                                 DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/H2POPB.TTF";                                 DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/H2POPL.TTF";                                 DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/H2POPM.TTF";                                 DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/H2PORB.TTF";                                 DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/H2PORL.TTF";                                 DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/H2PORM.TTF";                                 DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/H2ROSM.TTF";                                 DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/H2SAMB.TTF";                                 DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/H2SAML.TTF";                                 DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/H2SAMM.TTF";                                 DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/H2SANB.TTF";                                 DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/H2SANL.TTF";                                 DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/H2SANM.TTF";                                 DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/H2SNRB.TTF";                                 DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/H2SNRL.TTF";                                 DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/H2SORB.TTF";                                 DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/H2SUPB.TTF";                                 DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/H2SUPE.TTF";                                 DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/H2SUPL.TTF";                                 DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/H2SUPM.TTF";                                 DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/H2SYM1.TTF";                                 DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/H2SYM2.TTF";                                 DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/H2SYM3.TTF";                                 DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/H2SYM4.TTF";                                 DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/H2SYM5.TTF";                                 DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/H2SYM6.TTF";                                 DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/H2SYM7.TTF";                                 DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/H2SYM8.TTF";                                 DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/H2T1SE.TTF";                                 DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/H2T2SB.TTF";                                 DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/H2T2SE.TTF";                                 DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/H2T2SL.TTF";                                 DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/H2T2SM.TTF";                                 DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/H2TA1B.TTF";                                 DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/H2TA1L.TTF";                                 DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/H2TA1M.TTF";                                 DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/H2TA2B.TTF";                                 DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/H2TA2L.TTF";                                 DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/H2TA2M.TTF";                                 DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/H2TBRB.TTF";                                 DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/H2WULB.TTF";                                 DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/H2WULE.TTF";                                 DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/H2WULL.TTF";                                 DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/H2WULM.TTF";                                 DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/H2YERB.TTF";                                 DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/H2YERM.TTF";                                 DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/H2YOYB.TTF";                                 DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/H2YOYL.TTF";                                 DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/H2YOYM.TTF";                                 DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/H2YSRM.TTF";                                 DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/HYAfternoon-Medium.ttf";                     DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/HYBabypink-Bold.ttf";                        DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/HYBabypink-Medium.ttf";                      DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/HYBakery-Bold.ttf";                          DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/HYBakery-Medium.ttf";                        DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/HYBbuing-Medium.ttf";                        DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/HYBlackTea-Medium.ttf";                      DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/HYBlueGreen-Bold.ttf";                       DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/HYBlueGreen-Light.ttf";                      DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/HYBlueGreen-Medium.ttf";                     DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/HYBongja-Medium.ttf";                        DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/HYBonjour-Medium.ttf";                       DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/HYBubble-Medium.ttf";                        DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/HYBusstop-Medium.ttf";                       DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/HYChampion-Medium.ttf";                      DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/HYChocochip-Medium.ttf";                     DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/HYChocopie-Bold.ttf";                        DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/HYChocopie-Medium.ttf";                      DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/HYCoffee-Bold.ttf";                          DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/HYCoffee-Medium.ttf";                        DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/HYComfort-Medium.ttf";                       DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/HYComic-Medium.ttf";                         DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/HYCookie-Bold.ttf";                          DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/HYCookie-Medium.ttf";                        DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/HYCute-Bold.ttf";                            DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/HYCute-Medium.ttf";                          DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/HYDailyDaily-Bold.ttf";                      DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/HYDailyDaily-Light.ttf";                     DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/HYDailyDaily-Medium.ttf";                    DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/HYDaisy-Bold.ttf";                           DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/HYDaisy-Medium.ttf";                         DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/HYDiving-Medium.ttf";                        DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/HYDream-Bold.ttf";                           DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/HYDream-Medium.ttf";                         DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/HYDrive-Bold.ttf";                           DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/HYDrive-Medium.ttf";                         DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/HYElephant-Medium.ttf";                      DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/HYEndor-Medium.ttf";                         DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/HYFlower-Bold.ttf";                          DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/HYFlower-Medium.ttf";                        DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/HYFoxrain-Bold.ttf";                         DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/HYFoxrain-Medium.ttf";                       DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/HYFridaynight-Medium.ttf";                   DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/HYFriend-Bold.ttf";                          DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/HYFriend-Medium.ttf";                        DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/HYGangbuk-Medium.ttf";                       DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/HYGirlWorld-Medium.ttf";                     DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/HYGothic-Extended.TTF";                      DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/HYGothic_A1_100.ttf";                        DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/HYGothic_A1_200.ttf";                        DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/HYGothic_A1_300.ttf";                        DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/HYGothic_A1_400.ttf";                        DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/HYGothic_A1_500.ttf";                        DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/HYGothic_A1_600.ttf";                        DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/HYGothic_A1_700.ttf";                        DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/HYGothic_A1_800.ttf";                        DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/HYGothic_A1_900.ttf";                        DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/HYGothic_B1_100.ttf";                        DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/HYGothic_B1_200.ttf";                        DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/HYGothic_B1_300.ttf";                        DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/HYGothic_B1_400.ttf";                        DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/HYGothic_B1_500.ttf";                        DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/HYGothic_B1_600.ttf";                        DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/HYGothic_B1_700.ttf";                        DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/HYGothic_B1_800.ttf";                        DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/HYGothic_B1_900.ttf";                        DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/HYGothic_C1_100.ttf";                        DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/HYGothic_C1_200.ttf";                        DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/HYGothic_C1_300.ttf";                        DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/HYGothic_C1_400.ttf";                        DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/HYGothic_C1_500.ttf";                        DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/HYGothic_C1_600.ttf";                        DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/HYGothic_C1_700.ttf";                        DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/HYGothic_C1_800.ttf";                        DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/HYGothic_C1_900.ttf";                        DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/HYHaeSo-Extended.TTF";                       DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/HYHappy-Bold.ttf";                           DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/HYHappy-Medium.ttf";                         DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/HYHappywing-Bold.ttf";                       DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/HYHappywing-Medium.ttf";                     DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/HYHispring-Bold.ttf";                        DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/HYHispring-Medium.ttf";                      DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/HYIceheart-Bold.ttf";                        DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/HYIceheart-Medium.ttf";                      DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/HYIcicle-Bold.ttf";                          DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/HYIcicle-Light.ttf";                         DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/HYIcicle-Medium.ttf";                        DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/HYIcuBanana-Medium.ttf";                     DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/HYIdiot-Medium.ttf";                         DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/HYKid-Bold.ttf";                             DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/HYKid-Medium.ttf";                           DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/HYKindGothic-Bold.ttf";                      DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/HYKindGothic-Light.ttf";                     DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/HYKindGothic-Medium.ttf";                    DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/HYLizardw-Medium.ttf";                       DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/HYLollol-Medium.ttf";                        DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/HYLoveu-Bold.ttf";                           DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/HYLoveu-Medium.ttf";                         DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/HYMemory-Medium.ttf";                        DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/HYMerryberry-Medium.ttf";                    DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/HYMilkchoco-Bold.ttf";                       DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/HYMilktea-Bold.ttf";                         DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/HYMilktea-Medium.ttf";                       DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/HYMinggu-Medium.ttf";                        DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/HYMoment-Medium.ttf";                        DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/HYNow-Bold.ttf";                             DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/HYNow-Medium.ttf";                           DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/HYNylonPanty-Bold.ttf";                      DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/HYOffice-Bold.ttf";                          DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/HYOffice-Light.ttf";                         DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/HYOffice-Medium.ttf";                        DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/HYOneWay-Medium.ttf";                        DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/HYPuppy-Bold.ttf";                           DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/HYPuppy-Medium.ttf";                         DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/HYPurewhite-Bold.ttf";                       DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/HYPurewhite-Medium.ttf";                     DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/HYRain-Medium.ttf";                          DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/HYRomance-Bold.ttf";                         DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/HYRomance-Medium.ttf";                       DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/HYSalon-Bold.ttf";                           DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/HYSaying-Bold.ttf";                          DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/HYSaying-Medium.ttf";                        DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/HYShoulder-Medium.ttf";                      DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/HYShower-Bold.ttf";                          DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/HYShower-Light.ttf";                         DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/HYShower-Medium.ttf";                        DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/HYSilhouette-Bold.ttf";                      DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/HYSilhouette-Light.ttf";                     DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/HYSilhouette-Medium.ttf";                    DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/HYSmallAttract-Medium.ttf";                  DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/HYSMyeongJo-Extended.TTF";                   DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/HYSprout-Bold.ttf";                          DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/HYSprout-Medium.ttf";                        DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/HYStar-Bold.ttf";                            DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/HYStar-Medium.ttf";                          DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/HYSulk-Medium.ttf";                          DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/HYT2L-Bold.ttf";                             DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/HYT2L-Medium.ttf";                           DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/HYToe-Bold.ttf";                             DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/HYToe-Medium.ttf";                           DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/HYTravel-Bold.ttf";                          DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/HYTravel-Medium.ttf";                        DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/HYTV-Bold.ttf";                              DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/HYUfo-Bold.ttf";                             DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/HYUfo-Medium.ttf";                           DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/HYWhale-Medium.ttf";                         DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/HYYoungStar-Medium.ttf";                     DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion
Source: "fonts/HYYouthful-Medium.ttf";                      DestDir: "{#MyAppRootPath}\{#MyAppDataName}\down\";                        Flags: ignoreversion


[Code]
type
    TProcessEntry = record
        PID:    DWORD;
        Name:   string;
    end;
    TProcessEntryList = array of TProcessEntry;

    
function GetProcessList(const Filter: string; out List: TProcessEntryList): Integer;
var
    I:              Integer;
    WQLQuery:       string;
    WbemLocator:    Variant;
    WbemServices:   Variant;
    WbemObject:     Variant;
    WbemObjectSet:  Variant;
begin
    Result          := 0;
    WbemLocator     := CreateOleObject('WbemScripting.SWbemLocator');
    WbemServices    := WbemLocator.ConnectServer('localhost', 'root\CIMV2');
    WQLQuery        := 'SELECT ProcessId, Name FROM Win32_Process WHERE Name LIKE "%' + Filter +'%"';
    WbemObjectSet   := WbemServices.ExecQuery(WQLQuery);
    if not VarIsNull(WbemObjectSet) and (WbemObjectSet.Count > 0) then
    begin
        Result := WbemObjectSet.Count;
        SetArrayLength(List, WbemObjectSet.Count);
        for I := 0 to WbemObjectSet.Count - 1 do
        begin
            WbemObject := WbemObjectSet.ItemIndex(I);
            if not VarIsNull(WbemObject) then
            begin
                List[I].PID := WbemObject.ProcessId;
                List[I].Name := WbemObject.Name;
            end;
        end;
    end;
end;


function IsFontManagerProcesss: Boolean;
var
    I:              Integer;
    Filter:         string;
    ProcessList:    TProcessEntryList;
begin
    Filter  := '{#MyAppFilter}';
    Result  := false;
    if GetProcessList(Filter, ProcessList) > 0 then
        for I := 0 to (GetArrayLength(ProcessList) - 1) do
        begin
            if CompareText(Filter, ProcessList[I].Name) = 0 then
            begin
                Result := True;
                Exit;
            end
        end;
end;


function IsFontbadaManagerWindow: Boolean;
begin
    Result := (FindWindowByWindowName('{#MyAppWindowName}') <> 0);
end;


function GetUninstallString: string;
var
    sUnInstPath:        string;
    sUnInstallString:   string;
begin
    Result := '';
    sUnInstPath := ExpandConstant('Software\Microsoft\Windows\CurrentVersion\Uninstall\{{A2670E5F-4D34-4042-A9C5-5A3BC9547B37}_is1');
    sUnInstallString := '';
    if not RegQueryStringValue(HKLM, sUnInstPath, 'UninstallString', sUnInstallString) then
        RegQueryStringValue(HKCU, sUnInstPath, 'UninstallString', sUnInstallString);
    Result := sUnInstallString;
end;


function IsWindowsVersionOrNewer(Major, Minor: Integer): Boolean;
var
    Version: TWindowsVersion;
begin
    GetWindowsVersionEx(Version);
    Result := (Version.Major > Major) or ((Version.Major = Major) and (Version.Minor >= Minor));
end;


procedure InitializeWizard;
begin
    with TNewStaticText.Create(WizardForm) do
    begin
        Left    := WizardForm.FilenameLabel.Left;
        Top     := WizardForm.FilenameLabel.Top;
        Width   := WizardForm.FilenameLabel.Width;
        Height  := WizardForm.FilenameLabel.Height;
        Caption := ExpandConstant('Ʈٴ3 ġ...');
    end;
    WizardForm.FilenameLabel.Visible := False;
end;


function CheckRunProcess: Boolean;
begin
    Result := True;
    if IsFontManagerProcesss and IsFontbadaManagerWindow then
    begin
        MsgBox('Ʈٴ Ŵ({#MyAppWindowName})  Դϴ.  (α ƿ)  ٽ  ּ.', mbCriticalError, MB_OK);
        Result := False;
    end;
end;


function InitializeSetup: Boolean;
var
    ResultCode:         Integer;
    UnInstallString:    string;
begin
    Result    := False;

    // Ʈٴ Ŵ   Ȯ
    if CheckRunProcess = False then
    begin
        Exit;
    end

    // ν緯 Ȯ
    if RegValueExists(HKEY_LOCAL_MACHINE,'Software\Microsoft\Windows\CurrentVersion\Uninstall\{A2670E5F-4D34-4042-A9C5-5A3BC9547B37}_is1', 'UninstallString') then
    begin
        MsgBox(ExpandConstant('  Ʈٴ Ŵ մϴ.   ġ մϴ.'), mbInformation, MB_OK);
        UnInstallString := GetUninstallString();
        UnInstallString := RemoveQuotes(UnInstallString);
        Exec(ExpandConstant(UnInstallString), '', '', SW_SHOW, ewWaitUntilTerminated, ResultCode);
        // Log(Format('UnInstall ResultCode -> [ %d ]', [ResultCode]));
        if ResultCode > 0 then
        begin
            Exit;
        end;
    end;
    Result := True;
end;


[Icons]
Name: {userdesktop}\Ʈٴ; Filename: {#MyAppPrjFilePath}\{#MyAppFolderName}\{#MyAppProcessName}.exe; WorkingDir: {#MyAppPrjFilePath}\{#MyAppFolderName}\; Comment: "Ʈٴ Ŵ"; IconFilename: {#MyAppPrjFilePath}\{#MyAppFolderName}\{#MyAppProcessName}.exe;
Name: {userstartup}\Ʈٴ; Filename: {#MyAppPrjFilePath}\{#MyAppFolderName}\{#MyAppProcessName}.exe; workingdir: {#MyAppPrjFilePath}\{#MyAppFolderName}\;


[Run]
Filename: "schtasks";Parameters: "/create /sc onLogon /tn FontManager /tr /f ""'{#MyAppPrjFilePath}\{#MyAppFolderName}\{#MyAppProcessName}.exe'"" /RL HIGHEST /DELAY 0000:10"; Flags:ShellExec;
Filename: {#MyAppPrjFilePath}\{#MyAppFolderName}\{#MyAppProcessName}.exe; Flags: nowait postinstall skipifsilent;